/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutput
extends DataOutputStream {
    public DataOutput(OutputStream out) {
        super(out);
    }

    public int writeInt(int value2, boolean optimizePositive) throws IOException {
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            this.write((byte)value2);
            return 1;
        }
        this.write((byte)(value2 & 0x7F | 0x80));
        if (value2 >>> 14 == 0) {
            this.write((byte)(value2 >>> 7));
            return 2;
        }
        this.write((byte)(value2 >>> 7 | 0x80));
        if (value2 >>> 21 == 0) {
            this.write((byte)(value2 >>> 14));
            return 3;
        }
        this.write((byte)(value2 >>> 14 | 0x80));
        if (value2 >>> 28 == 0) {
            this.write((byte)(value2 >>> 21));
            return 4;
        }
        this.write((byte)(value2 >>> 21 | 0x80));
        this.write((byte)(value2 >>> 28));
        return 5;
    }

    public void writeString(String value2) throws IOException {
        char c;
        int charIndex;
        if (value2 == null) {
            this.write(0);
            return;
        }
        int charCount = value2.length();
        if (charCount == 0) {
            this.writeByte(1);
            return;
        }
        this.writeInt(charCount + 1, true);
        for (charIndex = 0; charIndex < charCount && (c = value2.charAt(charIndex)) <= '\u007f'; ++charIndex) {
            this.write((byte)c);
        }
        if (charIndex < charCount) {
            this.writeString_slow(value2, charCount, charIndex);
        }
    }

    private void writeString_slow(String value2, int charCount, int charIndex) throws IOException {
        while (charIndex < charCount) {
            char c = value2.charAt(charIndex);
            if (c <= '\u007f') {
                this.write((byte)c);
            } else if (c > '\u07ff') {
                this.write((byte)(0xE0 | c >> 12 & 0xF));
                this.write((byte)(0x80 | c >> 6 & 0x3F));
                this.write((byte)(0x80 | c & 0x3F));
            } else {
                this.write((byte)(0xC0 | c >> 6 & 0x1F));
                this.write((byte)(0x80 | c & 0x3F));
            }
            ++charIndex;
        }
    }
}

